// <copyright file="MasterPLCAdapter.js" company="">
// , 2014
// </copyright>
// 


define(['helpers/contextResolver', 'common/Utilites', 'common/Error'], function (contextResolver, Utilites, Error) {
    //settings {
    //context: ''  (  , '/')
    //path: '' -   
    //propertyPath -     , . propertyName
    //}

    var BaseAdapter = Class.extend({
        init: function (settings, type) {
            this.settings = settings;
            this.propertyPath = this.settings.propertyPath;
            this.adapterType = "BaseAdapter";
        },

        get: function (sender) {
            return this.getDataSource(sender).getProperty(this.propertyPath);
        },     

        getType: function (sender) {
            return this.getDataSource(sender).getPropertyType(this.propertyPath);
        },

        set: function (sender, newValue, operation, sourceOldValue) {
            //sourceOldValue -     -
            //  SvgAdapter
            var currentValue = this.get(sender);            
            newValue.value = Utilites.calculate(currentValue != undefined ? currentValue.value : undefined, newValue.value, operation);

            if (newValue.value === undefined) {
                //Error.debug(String.format('Possible error in {0} adaper: property name: {1} object {2} value: {3} operatin {4}',
                //    this.adapterType, name, Utilites.stringifyObj(newValue), Utilites.stringifyObj(newValue.value), operation));
                return;
            }

            this.getDataSource(sender).setProperty(this.propertyPath, newValue, false, false);
            currentValue = null;
        },

        getDataSource: function (ctx) {
            return contextResolver.resolve(this.settings.path, ctx).model;
        }

    });

    return BaseAdapter;
});