﻿define(['common/Enums', 'core/convertations/ConvertationUsage', 'core/convertations/ConvertationTypes', 'common/Error'], 
	function (enums, ConvertationUsage, ConvertationTypes, error) {

	function ConvertationChain(settings) {
		this.convertations = [];
		this.init(settings);
	};

	ConvertationChain.prototype.init = function(settings) {
		for(var i = 0, l = settings.length; i < l; ++i) {
			var convertation = this.extend(new ConvertationUsage(settings[i]));
			this.convertations.push(convertation);
			if(this.convertations[i - 1] && 
				ConvertationTypes.get(this.convertations[i - 1].typeId).targetType !== ConvertationTypes.get(this.convertations[i].typeId).sourceType) {
				error.onerror("Target type of convertation in chain is not equals to source type of previous convertation in chain.");
			}
		}
	};
	
	ConvertationChain.prototype.extend = function(convertation) {
		var type = ConvertationTypes.get(convertation.typeId);
		for(var i in type.points) {
			// копируем опорные точки из типа в экземпляр
			if(!convertation.points.hasOwnProperty(i)) {
				convertation.points[i] = Object.create(type.points[i]);
			}
		}

		// Делаем ссылку на правило конвертации из типа
		convertation.convertationRule = type.convertationRule;
		if(convertation.defaultValue === undefined) {
			convertation.defaultValue = type.defaultValue;
		}

		// После того, как точки скопированы, можно создать для них адаптеры
		convertation.createPointAdapters();
		return convertation;
	};

	ConvertationChain.prototype.convert = function(value, context) {
		for(var i = 0, l = this.convertations.length; i < l; ++i) {
			value = this.convertations[i].convert(value, context);
		}

		return value;
	};


	return ConvertationChain;
});