﻿define(['core/AdapterFactory', 'common/Utilites', 'common/Enums'], function (AdapterFactory, Utilities, enums) {

    function ConvertationType(settings) {
        this.init(settings);
    }

    ConvertationType.prototype.init = function (options) {
        if (options instanceof Object) {
            $.extend(this, options || {});
        }
        if (this.defaultValue == undefined) {
            this.convertationRule = directConvert;
        }
        else {
            var defCtor = AdapterFactory.getByType(this.defaultValue.type);
            this.defaultValue = new defCtor(this.defaultValue);
            defCtor = null;

            this.chooseConvertationRule();
        }
    }


    ConvertationType.prototype.chooseConvertationRule = function () {
        if (!this.interpolateSource && !this.interpolateTarget) {
            this.convertationRule = tableConvert;
        } else if (this.interpolateSource && !this.interpolateTarget) {
            this.convertationRule = pointInterpolation;
        } else if (!this.interpolateSource && this.interpolateTarget) {
            this.convertationRule = reversePointInterpolation;
        } else if (this.interpolateSource && this.interpolateTarget) {
            this.convertationRule = interpolation;
        }
    };


    // All this funcitons will be called in context of ConvertationUsage
    function tableConvert(variable) {
        for (var i = 0, l = this.sourcePoints.length; i < l; i++) {
            if (variable.toString().toLowerCase() === this.sourcePoints[i].toString().toLowerCase()) {
                return this.targetPoints[i];
            }
        }
    };

    function pointInterpolation(variable) {
        if (typeof (variable) === "string")
            variable = Number(variable);
        for (var i = 0, l = this.sourcePoints.length - 1; i < l; i++) {
            if (this.sourcePoints[i] <= variable && variable < this.sourcePoints[i + 1]) {
                return this.targetPoints[i];
            }
        }

        if (variable >= this.sourcePoints[this.sourcePoints.length - 1]) {
            return this.targetPoints[this.targetPoints.length - 1];
        }
    };

    function reversePointInterpolation(variable) {
        for (var i = 0, l = this.sourcePoints.length - 1; i < l; i++) {
            if (this.sourcePoints[i] <= variable && variable < this.sourcePoints[i + 1]) {
                return this.targetPoints[i + 1];
            }
        }
    };

    function interpolation(variable) {
        if (typeof (variable) === "string")
            variable = Number(variable);
        if (variable < this.sourcePoints[0]) {
            return this.targetPoints[0];
        } else if (variable >= this.sourcePoints[this.sourcePoints.length - 1]) {
            return this.targetPoints[this.targetPoints.length - 1];
        }

        for (var i = 0, l = this.sourcePoints.length - 1; i < l; i++) {
            if (this.sourcePoints[i] <= variable && variable < this.sourcePoints[i + 1]) {
                return interpolate.call(this, variable, i);
            }
        }
    };

    function interpolate(variable, i) {
        var tmps = Utilities.GetIntervalPercentValue(variable, this.sourcePoints[i], this.sourcePoints[i + 1]);
        if (this.type.targetType === enums.ConvertationType.brush) {
            var color = Utilities.getMiddleColor(this.targetPoints[i], this.targetPoints[i + 1], tmps);
            return color;
        } else if (this.type.targetType === enums.ConvertationType.matrix) {
            var color = Utilities.getMiddleMatrixColor(this.targetPoints[i], this.targetPoints[i + 1], tmps);
            return color;
        } else {
            tmps = Utilities.GetIntervalValue(tmps, this.targetPoints[i], this.targetPoints[i + 1]);
            return tmps;
        }
    };

    function directConvert(value) {
        return value;
    }

    return ConvertationType;
});
