﻿define(['common/Error'], function (Error) {

    var SoundService = {};
    var sounds = {};
    var play_queue = [];
    var isPlayingSomething = false;
    SoundService.call = function (param) {
        if (!param.Sound) {
            return;
        }
        if (!sounds[param.Sound]) {
            sounds[param.Sound] = new Audio(param.Sound);
            sounds[param.Sound].addEventListener("ended", this.onAudioEnded);
        }
        var sound_index = SoundService.findInQueue(param.Sound);
        if (sound_index != null) {
            play_queue[sound_index].repeat = param.Rep;
            play_queue[sound_index].priority = param.Priority;
            return;
        } else {
            if (param.Play) {
                play_queue.push({
                    sound: sounds[param.Sound],
                    title: param.Sound,
                    repeat: param.Rep,
                    priority: param.Priority
                });
                if (!isPlayingSomething) {
                    isPlayingSomething = true;
                    sounds[param.Sound].play();
                }
            }
        }
    };
    SoundService.stop = function (param) {
        if (param.Stop)
            if (isPlayingSomething) {
                var sound_index = SoundService.findInQueue(param.Sound);
                if (sound_index != null) {
                    isPlayingSomething = false;
                    sounds[param.Sound].pause();
                    sounds[param.Sound].currentTime = 0;
                    play_queue.splice(sound_index, 1);
                }
            }
        if (!isPlayingSomething && play_queue.length > 0) {
            play_queue[0].sound.play();
            isPlayingSomething = true;
        }
    };

    SoundService.onAudioEnded = function () {
        if (play_queue.length == 0) {
            isPlayingSomething = false;
            return;
        }
        if (play_queue[0].repeat) {
            play_queue.push(play_queue[0]);
        }
        play_queue.shift();
        if (play_queue.length > 0) {
            play_queue[0].sound.play();
        }
        else {
            isPlayingSomething = false;
        }
    }
    SoundService.isInQueue = function (sound) {
        for (var i = 0; i < play_queue.length; i++) {
            if (play_queue[i].title == sound) {
                return true;
            }
        }
        return false;
    }
    SoundService.findInQueue = function (sound) {
        for (var i = 0; i < play_queue.length; i++) {
            if (play_queue[i].title == sound) {
                return i;
            }
        }
        return null;
    }

    return SoundService;
});