﻿// <copyright file="formating.js" company="ИнСАТ">
// ИнСАТ, 2012
// </copyright>
// 

(function () {

    //-------- CultureInfo

    //var _percentPositivePattern = ["n %", "n%", "%n"];
    //var _percentNegativePattern = ["-n %", "-n%", "-%n"];
    //var _numberNegativePattern = ["(n)", "-n", "- n", "n-", "n -"];
    //var _currencyPositivePattern = ["$n", "n$", "$ n", "n $"];
    //var _currencyNegativePattern = ["($n)", "-$n", "$-n", "$n-", "(n$)", "-n$", "n-$", "n$-", "-n $", "-$ n", "n $-", "$ n-", "$ -n", "n- $", "($ n)", "(n $)"];

    var CultureInfo = {};
    CultureInfo.current = {
        numberFormat: {
            currencyNegativePattern: "-n$",
            currencyPositivePattern: "n$",
            currencyGroupSizes: [3],
            currencyGroupSeparator: ",",
            currencyDecimalSeparator: ".",
            currencyDecimalDigits: "2",
            currencySymbol: " ₽",

            negativeSign: "-",
            numberNegativePattern: "-n",
            numberGroupSizes: [3],
            numberGroupSeparator: ",",
            numberDecimalSeparator: ".",
            numberDecimalDigits: 2,
            numberExpDigits: 6,

            percentNegativePattern: "-n%",
            percentPositivePattern: "n%",
            percentGroupSizes: [3],
            percentGroupSeparator: ",",
            percentDecimalSeparator: ".",
            percentDecimalDigits: 2,
            percentSymbol: "%"
        },

        dateTimeFormat: {
            eras: [1, "A.D.", null, 0],

            dateSeparator: "/",
            timeSeparator: ":",

            shortDatePattern: "MM/dd/yyyy",
            longDatePattern: "dddd, dd MMMM yyyy",
            shortTimePattern: "HH:mm",
            longTimePattern: "HH:mm:ss",
            fullDateTimePattern: "dddd, dd MMMM yyyy HH:mm:ss",
            monthDayPattern: "MMMM dd",
            sortableDateTimePattern: "yyyy'-'MM'-'dd'T'HH':'mm':'ss",
            yearMonthPattern: "yyyy MMMM",

            dayNames: ['Воскресенье', 'Понедельник', 'Вторник', 'Среда', 'Четверг', 'Пятница', 'Суббота'],
            abbreviatedDayNames: ['Вс', 'Пн', 'Вт', 'Ср', 'Чт', 'Пт', 'Сб'],

            monthGenitiveNames: ['Январь', 'Февраль', 'Март', 'Апрель', 'Май', 'Июнь', 'Июль', 'Август', 'Сентябрь', 'Октябрь', 'Ноябрь', 'Декабрь', ''],
            monthNames: ['Январь', 'Февраль', 'Март', 'Апрель', 'Май', 'Июнь', 'Июль', 'Август', 'Сентябрь', 'Октябрь', 'Ноябрь', 'Декабрь', ''],
            abbreviatedMonthGenitiveNames: ['Янв', 'Фев', 'Мар', 'Апр', 'Май', 'Июн', 'Июл', 'Авг', 'Сен', 'Окт', 'Ноя', 'Дек', ''],
            abbreviatedMonthNames: ['Янв', 'Фев', 'Мар', 'Апр', 'Май', 'Июн', 'Июл', 'Авг', 'Сен', 'Окт', 'Ноя', 'Дек', ''],

            AMDesignator: "AM",
            PMDesignator: "PM"
        }
    };

    String.formatByArray = function (format, args) {
        var arr = [format];
        arr.push.apply(arr, args);
        return String._formatInternal(arr);
    }

    String.format = function (format, args) {

        return String._formatInternal(arguments);
    }

    String._formatInternal = function (args) {
        var result = '';
        var format = args[0];

        if (!format) {
            return args[1];
        }

        var open = format.indexOf('{');
        var close = format.indexOf('}');
        if ((open < 0) && (close < 0)) {
            if (args[1] === undefined) {
                return args[1];
            }
            // Not found: just replace all
            if (args[1] === undefined) {
                return args[1];
            }

            result = stringToValue(args[1], format);
            if (result.formatToString) {
                return result.formatToString(format);
            }
            else
                return result.toString();
        }

        for (var i = 0; ;) {
            // Find the next opening or closing brace
            open = format.indexOf('{', i);
            close = format.indexOf('}', i);
            if ((open < 0) && (close < 0)) {               
                // Not found: copy the end of the string and break
                result += format.slice(i);
                break;
            }

            if ((close > 0) && ((close < open) || (open < 0))) {

                if (format.charAt(close + 1) !== '}') {
                    throw 'Не найдены парные фигурные скобки.';
                }

                //copy string including closing brace
                result += format.slice(i, close + 1);
                //start next loop from char after closing brace
                i = close + 2;
                continue;
            }

            // Copy the string before the brace
            result += format.slice(i, open);
            i = open + 1;

            // Check for double braces (which display as one and are not arguments)
            if (format.charAt(i) === '{') {
                //we have double brace, so add one to result and got to next loop
                result += '{';
                i++;
                continue;
            }

            if (close < 0) throw 'Не найдена закрывающая фигурная скобка';

            //
            // Find the closing brace

            // Get the string between the braces, and split it around the ':' (if any)
            var brace = format.substring(i, close);
            var colonIndex = brace.indexOf(':');         
            var argNumber = parseInt((colonIndex < 0) ? brace : brace.substring(0, colonIndex), 10) + 1;

            var argFormat = (colonIndex < 0) ? '' : brace.substring(colonIndex + 1);

            if (isNaN(argNumber)) {
                if (args.length === 2) {
                    argNumber = 1;
                    if (colonIndex < 0) {
                        argFormat = brace;
                    }
                }
                else {
                    throw 'Неправильный формат номера аргумента.';
                }
            }

            var arg = args[argNumber];
            if (typeof (arg) === "undefined" || arg === null) {
                arg = '';
            }

            //// hack to solve problem with number to string conversion
            ////because we always receive string values
            arg = stringToValue(arg, argFormat);


            // If it has a toFormattedString method, call it.  Otherwise, call toString()            
            if (arg.formatToString) {
                result += arg.formatToString(argFormat);
            }
            else
                result += arg.toString();

            i = close + 1;
        }

        return result;
    }

 /**
 * Return a new JSON object of the old string.
 * Turns:
 * 		file.js?a=1&amp;b.c=3.0&b.d=four&a_false_value=false&a_null_value=null
 * Into:
 * 		{"a":1,"b":{"c":3,"d":"four"},"a_false_value":false,"a_null_value":null}
 * @version 1.1.0
 * @date July 16, 2010
 * @since 1.0.0, June 30, 2010
 * @package jquery-sparkle {@link http://balupton.com/projects/jquery-sparkle}
 * @author Benjamin "balupton" Lupton {@link http://balupton.com}
 * @copyright (c) 2009-2010 Benjamin Arthur Lupton {@link http://balupton.com}
 * @license MIT License {@link http://creativecommons.org/licenses/MIT/}
 */
    String.prototype.queryStringToJSON = String.prototype.queryStringToJSON || function () {	// Turns a params string or url into an array of params
        // Prepare
        var params = String(this);
        // Remove url if need be
        params = params.substring(params.indexOf('?') + 1);
        // params = params.substring(params.indexOf('#')+1);
        // Change + to %20, the %20 is fixed up later with the decode
        params = params.replace(/\+/g, '%20');
        // Do we have JSON string
        if (params.substring(0, 1) === '{' && params.substring(params.length - 1) === '}') {	// We have a JSON string
            return eval(decodeURIComponent(params));
        }
        // We have a params string
        params = params.split(/\&(amp\;)?/);
        var json = {};
        // We have params
        for (var i = 0, n = params.length; i < n; ++i) {
            // Adjust
            var param = params[i] || null;
            if (param === null) { continue; }
            param = param.split('=');
            if (param === null) { continue; }
            // ^ We now have "var=blah" into ["var","blah"]

            // Get
            var key = param[0] || null;
            if (key === null) { continue; }
            if (typeof param[1] === 'undefined') { continue; }
            var value = param[1];
            // ^ We now have the parts

            // Fix
            key = decodeURIComponent(key);
            value = decodeURIComponent(value);
            try {
                // value can be converted
                value = eval(value);
            } catch (e) {
                // value is a normal string
            }

            // Set
            // window.console.log({'key':key,'value':value}, split);
            var keys = key.split('.');
            if (keys.length === 1) {	// Simple
                json[key] = value;
            }
            else {	// Advanced (Recreating an object)
                var path = '',
                    cmd = '';
                // Ensure Path Exists
                $.each(keys, function (ii, key) {
                    path += '["' + key.replace(/"/g, '\\"') + '"]';
                    jsonCLOSUREGLOBAL = json; // we have made this a global as closure compiler struggles with evals
                    cmd = 'if ( typeof jsonCLOSUREGLOBAL' + path + ' === "undefined" ) jsonCLOSUREGLOBAL' + path + ' = {}';
                    eval(cmd);
                    json = jsonCLOSUREGLOBAL;
                    delete jsonCLOSUREGLOBAL;
                });
                // Apply Value
                jsonCLOSUREGLOBAL = json; // we have made this a global as closure compiler struggles with evals
                valueCLOSUREGLOBAL = value; // we have made this a global as closure compiler struggles with evals
                cmd = 'jsonCLOSUREGLOBAL' + path + ' = valueCLOSUREGLOBAL';
                eval(cmd);
                json = jsonCLOSUREGLOBAL;
                delete jsonCLOSUREGLOBAL;
                delete valueCLOSUREGLOBAL;
            }
            // ^ We now have the parts added to your JSON object
        }
        return json;
    };

    function stringToValue(arg, argFormat) {
        if (argFormat === "") {
            return arg;
        }
        if (isNumberFormat(argFormat)) {
            if (isNumeric(arg)) {
                return Number(arg);
            } else {
                throw new NumFormatError(
                    arg + ' - не число. Преобразование в выбранный формат |' + argFormat + '| невозможно!', 
                    NaN,
                    arg
                );
            }
        } else {
            var date = new Date(arg);
            if (!isNaN(date)) {
                return date;
            }
        }
        return arg;
    }


    //-------------------------------------------------------------------------------------------------
    //Number format
    //-------------------------------------------------------------------------------------------------

    Number.prototype.formatToString = function (format) {
        if (!format || (format.length === 0) || (format === 'i')) {
            return this.toString();
        }

        if (!isFinite(this)) {
            return this.toString();
        }

        var nf = CultureInfo.current.numberFormat;

        var number = Math.abs(this);

        if (!format) {
            format = "D";
        }

        var precision = -1;

        if (format.length > 1) {
            precision = parseInt(format.slice(1), 10);
        }

        var pattern;

        switch (format.charAt(0)) {
            case "d":
            case "D":
                pattern = 'n';
                if (number % 1 === 0) {
                    precision === -1 ?
                        number = "" + number :
                        number = zeroPad("" + number, precision, true);
                } else {
                    number = this - (this % 1);
                    throw new NumFormatError(
                        this + ' - дробное число. Для преобразования в формат |' + format + '| число должно быть целым!',
                        number,
                        this
                    );
                }
                if (this < 0) {
                    number = "-" + number;
                }
                break;
            case "c":
            case "C":
                this < 0 ?
                    pattern = nf.currencyNegativePattern :
                    pattern = nf.currencyPositivePattern;

                if (precision === -1) {
                    precision = nf.currencyDecimalDigits;
                }
                number = numberToString(Math.abs(this), precision, nf.currencyGroupSizes, nf.currencyGroupSeparator, nf.currencyDecimalSeparator);
                break;
            case "f":
            case "F":
                pattern = 'n';
                if (precision === -1) {
                    precision = nf.numberDecimalDigits;
                }
                number = number.toFixed(precision);

                if (this < 0) {
                    number = "-" + number;
                }
                break;
            case "e":
            case "E":
                this < 0 ?
                    pattern = nf.numberNegativePattern :
                    pattern = 'n';

                if (precision === -1) {
                    precision = nf.numberExpDigits;
                }

                number = number.toExponential(precision);
                break;
            case "n":
            case "N":
                this < 0 ?
                    pattern = nf.numberNegativePattern :
                    pattern = 'n';

                if (precision === -1) {
                    precision = nf.numberDecimalDigits;
                }
                number = numberToString(Math.abs(this), precision, nf.numberGroupSizes, nf.numberGroupSeparator, nf.numberDecimalSeparator);
                break;
            case "p":
            case "P":
                this < 0 ?
                    pattern = nf.percentNegativePattern :
                    pattern = nf.percentPositivePattern;

                if (precision === -1) {
                    precision = nf.percentDecimalDigits;
                }
                number = numberToString(Math.abs(this) * 100, precision, nf.percentGroupSizes, nf.percentGroupSeparator, nf.percentDecimalSeparator);
                break;
            case "x":
            case "X":
                if (number % 1 === 0) {
                    this < 0 ?
                        pattern = nf.numberNegativePattern :
                        pattern = 'n';

                    number = number.toString(16);

                    format.charAt(0) === 'x' ?
                        number = zeroPad(number, precision, true).toLowerCase() :
                        number = zeroPad(number, precision, true).toUpperCase();
                } else {
                    number = (this - (this % 1)).toString(16);
                    throw new NumFormatError(
                        this + ' - дробное число. Для преобразования в формат |' + format + '| число должно быть целым!',
                        number,
                        this
                    );
                }
                break;
            default:
                if (this < 0) {
                    pattern = nf.numberNegativePattern;
                }
                else {
                    pattern = 'n';
                }
                number = numberCustomFormat(format, this, nf);
                break;
        }

        var regex = /n|\$|-|%/g;
        var ret = "";
        for (; ;) {
            var index = regex.lastIndex;
            var ar = regex.exec(pattern);
            ret += pattern.slice(index, ar ? ar.index : pattern.length);
            if (!ar)
                break;
            switch (ar[0]) {
                case "n":
                    ret += number;
                    break;
                case "$":
                    ret += nf.currencySymbol;
                    break;
                case "-":
                    if (/[0-9]/.test(number)) {
                        ret += nf.negativeSign;
                    }
                    break;
                case "%":
                    ret += nf.percentSymbol;
                    break;
            }
        }
        return ret;
    }  

    function expandDateFormat(dtf, format) {
        if (!format) {
            format = "F";
        }
        var len = format.length;
        if (len === 1) {
            switch (format) {
                case "d":
                    return dtf.shortDatePattern;
                case "D":
                    return dtf.longDatePattern;
                case "t":
                    return dtf.shortTimePattern;
                case "T":
                    return dtf.longTimePattern;
                case "f":
                    return dtf.longDatePattern + " " + dtf.shortTimePattern;
                case "F":
                    return dtf.fullDateTimePattern;
                case "g":
                    return dtf.shortDatePattern + " " + dtf.shortTimePattern;
                case "G":
                    return dtf.shortDatePattern + " " + dtf.longTimePattern;
                case "M":
                case "m":
                    return dtf.monthDayPattern;
                case "s":
                    return dtf.sortableDateTimePattern;
                case "Y":
                case "y":
                    return dtf.yearMonthPattern;
                default:
                    throw "Неизвестный спецификатор формата даты.";
            }
        }
        else if ((len === 2) && (format.charAt(0) === "%")) {
            format = format.charAt(1);
        }
        return format;
    }

    function addLeadingZero(num) {
        if (num < 10) {
            return '0' + num;
        }
        return num.toString();
    }

    function addLeadingZeros(num) {
        if (num < 10) {
            return '00' + num;
        }
        if (num < 100) {
            return '0' + num;
        }
        return num.toString();
    }

    function padYear(year) {
        if (year < 10) {
            return '000' + year;
        }
        else if (year < 100) {
            return '00' + year;
        }
        else if (year < 1000) {
            return '0' + year;
        }
        return year.toString();
    }

    function getDateTokenRegExp() {
        return /\/\:|dddd|ddd|dd|d|MMMM|MMM|MM|M|yyyy|yyy|yy|y|hh|h|HH|H|mm|m|ss|s|tt|t|fff|ff|f|zzz|zz|z|gg|g/g;
    }

    function appendDatePreOrPostMatch(preMatch, strBuilder) {
        var quoteCount = 0;
        var escaped = false;
        for (var i = 0, il = preMatch.length; i < il; i++) {
            var c = preMatch.charAt(i);
            switch (c) {
                case '\'':
                    if (escaped) strBuilder.value += "'";
                    else quoteCount++;
                    escaped = false;
                    break;
                case '\\':
                    if (escaped) strBuilder.value += "\\";
                    escaped = !escaped;
                    break;
                default:
                    strBuilder.value += c;
                    escaped = false;
                    break;
            }
        }
        return quoteCount;
    }

    function getPart(date, part) {
        switch (part) {
            case 0: return date.getFullYear();
            case 1: return date.getMonth();
            case 2: return date.getDate();
        }
    }

    function getDateEraYear(date, dtf, era, sortable) {
        var year = date.getFullYear();
        if (!sortable && dtf.eras) {
            year -= dtf.eras[era + 3];
        }
        return year;
    }

    function getDateEra(date, eras) {
        if (!eras) return 0;
        var start, ticks = date.getTime();
        for (var i = 0, l = eras.length; i < l; i += 4) {
            start = eras[i + 2];
            if ((start === null) || (ticks >= start)) {
                return i;
            }
        }
        return 0;
    }

    function isDate(val, format) {
        var date = getDateFromFormat(val, format);
        if (date == 0) { return false; }
        return true;
    }

    //---------- Utilites -----------------------------------------------------------------------------

    function zeroPad(str, count, left) {
        for (var l = str.length; l < count; l++) {
            str = (left ? ('0' + str) : (str + '0'));
        }
        return str;
    }

    function numberToString(number, precision, groupSizes, sep, decimalChar) {
        var curSize = groupSizes[0];
        var curGroupIndex = 1;
        var factor = Math.pow(10, precision);
        var rounded = (Math.round(number * factor) / factor);
        if (!isFinite(rounded)) {
            rounded = number;
        }
        number = rounded;
        var numberString = number.toString();
        var right = "";
        var exponent;
        var split = numberString.split(/e/i);
        numberString = split[0];
        exponent = (split.length > 1 ? parseInt(split[1]) : 0);
        split = numberString.split('.');
        numberString = split[0];
        right = split.length > 1 ? split[1] : "";
        var l;
        if (exponent > 0) {
            right = zeroPad(right, exponent, false);
            numberString += right.slice(0, exponent);
            right = right.substr(exponent);
        }
        else if (exponent < 0) {
            exponent = -exponent;
            numberString = zeroPad(numberString, exponent + 1, true);
            right = numberString.slice(-exponent, numberString.length) + right;
            numberString = numberString.slice(0, -exponent);
        }
        if (precision > 0) {
            if (right.length > precision) {
                right = right.slice(0, precision);
            }
            else {
                right = zeroPad(right, precision, false);
            }
            right = decimalChar + right;
        }
        else {
            right = "";
        }
        var stringIndex = numberString.length - 1;
        var ret = "";
        while (stringIndex >= 0) {
            if (curSize === 0 || curSize > stringIndex) {
                if (ret.length > 0)
                    return numberString.slice(0, stringIndex + 1) + sep + ret + right;
                else
                    return numberString.slice(0, stringIndex + 1) + right;
            }
            if (ret.length > 0)
                ret = numberString.slice(stringIndex - curSize + 1, stringIndex + 1) + sep + ret;
            else
                ret = numberString.slice(stringIndex - curSize + 1, stringIndex + 1);
            stringIndex -= curSize;
            if (curGroupIndex < groupSizes.length) {
                curSize = groupSizes[curGroupIndex];
                curGroupIndex++;
            }
        }
        return numberString.slice(0, stringIndex + 1) + sep + ret + right;
    }

    function numberCustomFormat(format, value, nf) {

        var groupingSeparator,
            groupingIndex,
            decimalSeparator,
            decimalIndex,
            roundFactor,
            result,
            i;

        if (!(value instanceof Number)) {
            return value;
        } else {

            groupingSeparator = ',';
            groupingIndex = format.lastIndexOf(groupingSeparator);
            decimalSeparator = '.';
            decimalIndex = format.indexOf(decimalSeparator);

            var integer = '',
                fraction = '',
                negative = value < 0,
                minFraction = format.substr(decimalIndex + 1).replace(/#/g, '').length,
                maxFraction = format.substr(decimalIndex + 1).length,
                powFraction = 10;

            value = Math.abs(value);

            if (decimalIndex != -1) {

                fraction = nf.numberDecimalSeparator;

                if (maxFraction > 0) {

                    roundFactor = 1000;
                    powFraction = Math.pow(powFraction, maxFraction);

                    var tempRound = Math.round(parseInt(value * powFraction * roundFactor -
                                Math.round(value) * powFraction * roundFactor, 10) / roundFactor);
                    var tempFraction = String(tempRound < 0 ? Math.round(parseInt(value * powFraction * roundFactor -
                                parseInt(value, 10) * powFraction * roundFactor, 10) / roundFactor) : tempRound)
                    var parts = value.toString().split('.');

                    if (typeof parts[1] != 'undefined') {
                        for (i = 0; i < maxFraction; i++) {
                            if (parts[1].substr(i, 1) == '0' && i < maxFraction - 1 &&
                                    tempFraction.length != maxFraction) {
                                tempFraction = '0' + tempFraction;
                            } else {
                                break;
                            }
                        }
                    }

                    for (i = 0; i < (maxFraction - fraction.length) ; i++) {
                        tempFraction += '0';
                    }

                    var symbol,
                        formattedFraction = '';

                    for (i = 0; i < tempFraction.length; i++) {
                        symbol = tempFraction.substr(i, 1);

                        if (i >= minFraction && symbol == '0' && /^0*$/.test(tempFraction.substr(i + 1))) {
                            break;
                        }

                        formattedFraction += symbol;
                    }

                    fraction += formattedFraction;
                }

                if (fraction == nf.numberDecimalSeparator) {
                    fraction = '';
                }
            }

            if (decimalIndex !== 0) {
                if (fraction != '') {
                    integer = String(parseInt(Math.round(value * powFraction) / powFraction, 10));
                } else {
                    integer = String(Math.round(value));
                }

                var grouping = nf.numberGroupSeparator;
                var groupingSize = 0;

                if (groupingIndex != -1) {
                    if (decimalIndex != -1) {
                        groupingSize = decimalIndex - groupingIndex;
                    } else {
                        groupingSize = format.length - groupingIndex;
                    }
                    groupingSize--;
                }

                if (groupingSize > 0) {
                    var count = 0,
                        formattedInteger = '';
                    i = integer.length;

                    while (i--) {
                        if (count !== 0 && count % groupingSize === 0) {
                            formattedInteger = grouping + formattedInteger;
                        }
                        formattedInteger = integer.substr(i, 1) + formattedInteger;
                        count++;
                    }
                    integer = formattedInteger;
                }

                var maxInteger, maxRegExp = /#|,/g;

                if (decimalIndex != -1) {
                    maxInteger = format.substr(0, decimalIndex).replace(maxRegExp, '').length;
                } else {
                    maxInteger = format.replace(maxRegExp, '').length;
                }

                var tempInteger = integer.length;

                for (i = tempInteger; i < maxInteger; i++) {
                    integer = '0' + integer;
                }
            }

            result = integer + fraction;
            return result;
        }
    }

    function isNumberFormat(format) {
        if ((/[edcnfpx]{1}[0-9]{1,3}/i.test(format)) || (format.length === 1 && /[edcnfpx]{1}/i.test(format))) {
            return true;
        }
        else {
            return false;
        }
    }

    function isNumeric(n) {
        return !isNaN(parseFloat(n)) && isFinite(n);
    }

    function NumFormatError(message, result, arg) {
        this.name = 'numberFormatError';
        this.message = message;
        this.result = result;
        this.arg = arg.toString();
    }

})();
