﻿(function (curl) {
    var config = {
        baseUrl: 'scripts/',
        packages: [
            { name: 'curl', location: 'libs/curl', main: 'curl' },
            { name: 'wire', location: 'libs/wire', main: 'wire' },
            { name: 'when', location: 'libs/when', main: 'when' },
            { name: 'meld', location: 'libs/meld', main: 'meld' }
        ]
    };

    curl(config);

    function loadScheme() {
        curl(['startup']);
    }

    function startup(id) {
        if (id !== undefined) {
            curl(['core/WindowsManager'], function (WindowsManager) {
                WindowsManager.setDefaultWindowById(id);
                loadScheme();
            })
        } else {
            loadScheme();
        }
    }

    curl(['controls/Login/LoginControl'], function (LoginControl) {

        if (window.location.protocol.indexOf('file') >= 0) {
            startup();
        } else {
            var control = new LoginControl(function (responce) {
                var startMnemoscheme;
                if (responce.operators && responce.currentOperator) {
                    startMnemoscheme = _.find(responce.operators, function(o) { return o.login == responce.currentOperator }).startMnemoscheme;
                } else {
                    startMnemoscheme = responce.startMnemoscheme;
                }
                if (!responce.noVisualization)
                    startup(startMnemoscheme);
            });
            control._controller.getLoginData().then(function () {
                if (control._controller.needLogin()) {
                    $$.document.append(control);
                }
            });
        }
    });
})(curl)