﻿// <copyright file="DataAdapter.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['helpers/XhrWrapper', 'common/Enums'],
    function (XhrWrapper, Enums) {

     var DataAdapterBase = Class.extend({
         stateVars :Enums.serverState,
         init: function (serverStateManager, model) {
             this.model = model;
             this.model.subscribePropertyChanged(this._onDataAdapterSettingsChanged, this);
             this._initOptions();
             this.serverStateManager = serverStateManager;
             this.sGet = this.serverStateManager.get.bind(this.serverStateManager);
             this.sSet = this.serverStateManager.set.bind(this.serverStateManager);             
         },

         _initOptions: function () {
             this.options = {
                 url: this.model.get(Enums.ParameterRoles.URL),
                 filter: this.model.get(Enums.ParameterRoles.FILTER)
             }
         },

         _onDataAdapterSettingsChanged: function (event) {
             switch (event.property) {
                 case Enums.ParameterRoles.URL:
                 case Enums.ParameterRoles.FILTER:
                     this._initOptions();
                     break;
             }          
         },

         getAll: function () {
             return this.sendQuery(Enums.queryType.get, this.options.filter).then(function (result) {
                 return result.data;
             });
         },

         writeData: function (items) {
             return this.sendQuery(Enums.queryType.put, this.options.filter, items);
         },

         sendQuery: function (command, filter, parameters) {
             var fullUrl =  this.options.url + (filter ? filter : '');
             return XhrWrapper.loadUrl(
             fullUrl,
             command,
             typeof parameters == 'string' ? parameters : JSON.stringify(parameters)).
             then(function (response) {
                 return Promise.resolve({ status: response.status, data: response.data, command: command, parameters: parameters });
             },
              function (response) {
                  response.data.queryType = command;                  
                  return Promise.reject({ status: response.status, data: response.data, url: fullUrl, command: command, parameters: parameters });
              });
         }

     });

     return DataAdapterBase;
 });